package w83b.w83bOperacionesPaso.w83bResultados;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.contrib.HSSFRegionUtil;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaReprCandTamEmpExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bRepresentantesCandTamEmp.xls";
		InputStream inputStream = W83bTablaReprCandTamEmpExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        Map representantes = (HashMap)contexto.get("w83bMapResultadosBean");
        W83bResultadosBean resultadoBean = (W83bResultadosBean)contexto.get("w83bResultadosBean");
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        HashMap datosDelDep=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);
	   
        HSSFRow row;
        HSSFCell cell;
 
        
        row = sheet.getRow((short)4); 
     
        
        StringBuffer tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDepEs");
        StringBuffer tituloImagenEu =  (StringBuffer)datosDelDep.get("tituloDepEu");
        cell = row.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        cell = row.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        
        tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDelelegacionEs");
        tituloImagenEu = (StringBuffer)datosDelDep.get("tituloDelelegacionEu");
       
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        row = sheet.getRow((short)9); 
        cell = row.getCell((short)0);
        StringBuffer titulo = new StringBuffer();
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloReprCandTamEmp_eu",idioma));
        titulo.append(" ");
        titulo.append("/");
        titulo.append(" ");
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloReprCandTamEmp_es",idioma));
        cell.setCellValue(titulo.toString());
        
        row = sheet.getRow((short)10); 
        cell = row.getCell((short)5); 
       
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaHistorico())){
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}));
    	}else{
    		cell.setCellValue("");    		
    	}		
   
        row = sheet.getRow((short)11); 
        cell = row.getCell((short)1);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.territorio",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / " +
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.territorio",W83bClsConstantes.CONSTANTE_CASTELLANO));
     
        cell = row.getCell((short)3); 

        if(StringUtils.isNotEmpty((resultadoBean.getDescTerritorio()))){
        	cell.setCellValue(resultadoBean.getDescTerritorio().toUpperCase());
        	sheet.addMergedRegion(new Region((short)11,(short)3,(short)11,(short)5));
        }
     
        
        row = sheet.getRow((short)12); 
        
        cell = row.getCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fecheleccionHasta",W83bClsConstantes.CONSTANTE_EUSKARA) +
        		" / " +
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fecheleccionHasta",W83bClsConstantes.CONSTANTE_CASTELLANO));

        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.certificaciones.fechaEleccionDesde",W83bClsConstantes.CONSTANTE_EUSKARA) +
        		" / " +
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fecheleccionDesde",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)6); 
        if(StringUtils.isNotEmpty((resultadoBean.getFechaEleccionHasta()))){
        	cell.setCellValue(resultadoBean.getFechaEleccionHasta());
        }
        
        cell = row.getCell((short)3); 
        if(StringUtils.isNotEmpty((resultadoBean.getFechaEleccionDesde()))){
        	cell.setCellValue(resultadoBean.getFechaEleccionDesde());
        }
 
        cell = row.getCell((short)7); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.fechaRegDefinitivoHasta",W83bClsConstantes.CONSTANTE_EUSKARA) +
        		" / " +
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.fechaRegDefinitivoHasta",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)10);  
        if(StringUtils.isNotEmpty((resultadoBean.getFechaRegistroDefinitivo()))){
        	cell.setCellValue(resultadoBean.getFechaRegistroDefinitivo());
        }
        cell = row.getCell((short)11); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.porComarca",W83bClsConstantes.CONSTANTE_EUSKARA) +
        		" / " +
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.porComarca",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)12); 
        if("comarca".equals(resultadoBean.getComarcaMunicipio()))
        		{
            		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());
        		}else{
        		    cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());
        		}
        
        cell = row.getCell((short)13); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.porMunicipio",W83bClsConstantes.CONSTANTE_EUSKARA) +
        		" / " +
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.porMunicipio",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)14); 
        if("municipio".equals(resultadoBean.getComarcaMunicipio()))
        		{
            		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());
        		}else{
        		    cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());
        		}
        
       
        
        Map mapRepresentantesOrdenado = new TreeMap(representantes);
        Set ref = mapRepresentantesOrdenado.keySet();
        
        int inicioRepeticion=16;
   	 
	
	  int lineaactual=inicioRepeticion;
	  HashMap datos;
	 
	  Map mapSindicatosOrdenado;
	  Map sindicatos;
	  HashMap datosSinditato;
	  Iterator itSindicatos;
	  Iterator it=ref.iterator();
	  SortedMap  sindiref;
	  Region  region;
	  String key;
	  String keySindi;
	  boolean vacio=true;
	  int tamaoTabla;
	  int hoja=1;
	  
       for(int i=0;it.hasNext();i++)
       {
    	   vacio=false;
    	  
    	   key=(String)it.next();
    	   datos=(HashMap)mapRepresentantesOrdenado.get(key);
    	   sindicatos=(HashMap)datos.get("datosSindicatos");
   	  	   mapSindicatosOrdenado= new TreeMap(sindicatos);//NOPMD
   	  	
   	  	 
   	  	   // La tabla va a tener cabecera de 
   	  	   //1 rowterritorio comarca municipio 1row 
   	  	   //+ 1 row separador+1 row tramos de tamaos 
   	  	   //+ 1row de totales
   	  	   //+ n row sindicatos 
   	  	   tamaoTabla=4+mapSindicatosOrdenado.size();
   	  	  //tenemos que mirar que si no entra deberemos de saltar.
   	  	  //La primera pagina tiene 47 lineas, entonces si nuestra tabla no supera esas lineas todo sigue su curso normal
   	  	   // sin embargo si supera controlaremos en que hoja se encuentra, para asignar a linea actual la primera linea de la siguiente hoja
   	  	   // primera pagina 47
   	  	   //siguentes paginas 31
   	  	   if(lineaactual+1+tamaoTabla> 49+((hoja-1)*34))
   	  		   {
   	  			  
   	  			   lineaactual=49+(34*(hoja-1))+1;
   	  			  hoja++;
   	  		   }
   	  		   
   	 
   	  	   if(i!=0)
	  	   {
	  		   
	  		   excel.copyRow(wb, sheet,  inicioRepeticion+1,  lineaactual+1);
	      		excel.copyRow(wb, sheet,  inicioRepeticion+2,  lineaactual+2);
	      		excel.copyRow(wb, sheet,  inicioRepeticion+3,  lineaactual+3);
	  	   }
     		row = sheet.createRow((short)lineaactual+1); 
     		 sheet.addMergedRegion(new Region(lineaactual+1,Short.parseShort("1"),lineaactual+1,Short.parseShort("4")));//NOPMD
     		 sheet.addMergedRegion(new Region(lineaactual+1,Short.parseShort("5"),lineaactual+1,Short.parseShort("10")));//NOPMD
     		 sheet.addMergedRegion(new Region(lineaactual+1,Short.parseShort("11"),lineaactual+1,Short.parseShort("15")));//NOPMD
     		cell=row.createCell((short)1);
     		cell.setCellStyle(excel.styleNegrita);
     		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.provincia",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.provincia",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": "+(String)datos.get("provinciaTxt")));

     		cell=row.createCell((short)5);
     		cell.setCellStyle(excel.styleNegrita);
     		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.comarca",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.comarca",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": "+(String)datos.get("comarcaTxt")));
        	if("municipio".equals(resultadoBean.getComarcaMunicipio()))
        			{
		        		cell=row.createCell((short)11);
		         		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.municipio",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.municipio",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": "+(String)datos.get("municipioTxt")));
		            	cell.setCellStyle(excel.styleNegrita);
        			}else{
        				cell=row.createCell((short)11);
		         		cell.setCellValue(W83bClsConstantes.VACIO);
		            	
        			}
        	
        	lineaactual=lineaactual+4;
        	
    	  	
    	  	sindiref = new	TreeMap(java.util.Collections.reverseOrder());//NOPMD
    	  	           
    	  	sindiref.putAll(mapSindicatosOrdenado);
    	  	//se ordena al reves pq me interesa
    	  	itSindicatos = sindiref.keySet().iterator();
    	  	            
    	  	for(int j=0;itSindicatos.hasNext();j++)
    	       {
    	    	   keySindi=(String)itSindicatos.next();
    	    	   datosSinditato=(HashMap)mapSindicatosOrdenado.get(keySindi);
    	    	   
    	    	  
    	    	   row = sheet.createRow((short)lineaactual); 
    	    	   sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("1"),lineaactual,Short.parseShort("2")));//NOPMD
	       	  		cell=row.createCell((short)1);	
	       	  		if(StringUtils.isNotEmpty((String)datosSinditato.get("siglas"))){
	       	  			cell.setCellValue((String)datosSinditato.get("siglas"));
	       	  		}
	       	  	    cell=row.createCell((short)2);	
	       	  	    
		       	  	cell=row.createCell((short)3);
		       		cell.setCellStyle(excel.styleCentrado);
	       	  		cell.setCellValue((short)((Integer)datosSinditato.get("tramo1")).intValue());
	       	  		
		       	  	cell=row.createCell((short)4);
		       		cell.setCellStyle(excel.styleCentrado);
	       	  		cell.setCellValue((short)((Integer)datosSinditato.get("tramo2")).intValue());
	       	  		
		       	  	cell=row.createCell((short)5);
		       		cell.setCellStyle(excel.styleCentrado);
	       	  		cell.setCellValue((short)((Integer)datosSinditato.get("tramo3")).intValue());
	       	  		
		       	  	cell=row.createCell((short)6);
		       		cell.setCellStyle(excel.styleCentrado);
	       	  		cell.setCellValue((short)((Integer)datosSinditato.get("tramo4")).intValue());
	       	  	sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("7"),lineaactual,Short.parseShort("8")));//NOPMD
		       	  	cell=row.createCell((short)7);
		       		cell.setCellStyle(excel.styleCentrado);
	       	  		cell.setCellValue((short)((Integer)datosSinditato.get("tramo5")).intValue());
	       	  	
	       	  	
	       	  		
		       	  	cell=row.createCell((short)9);
		       		cell.setCellStyle(excel.styleCentrado);
	       	  		cell.setCellValue((short)((Integer)datosSinditato.get("tramo6")).intValue());
		       	  	cell=row.createCell((short)10);
		       		cell.setCellStyle(excel.styleCentrado);
	       	  		cell.setCellValue((short)((Integer)datosSinditato.get("tramo7")).intValue());
		       	  	cell=row.createCell((short)11);
		       		cell.setCellStyle(excel.styleCentrado);
	       	  		cell.setCellValue((short)((Integer)datosSinditato.get("tramo8")).intValue());
	       	  	  	cell=row.createCell((short)12);
	       	  	  	cell.setCellStyle(excel.styleCentrado);
	       	  		cell.setCellValue((short)((Integer)datosSinditato.get("tramo9")).intValue());
	       	  	  	
	       	  	  	cell=row.createCell((short)13);
	       	  	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	       	  		cell.setCellValue((short)((Integer)datosSinditato.get("tramoTotal")).intValue());
	       	  		
	       	  		if(j==0)
	       	  		{
	       	  		  region = new Region(lineaactual,(short)2,lineaactual,(short)13);//NOPMD
	       	  		  HSSFRegionUtil.setBorderTop((short)1, region, sheet, wb);
	                  HSSFRegionUtil.setTopBorderColor((short)0, region, sheet, wb);
	       	  		}
	       	  		lineaactual++;
    	       }
    	     region = new Region(lineaactual-1,(short)3,lineaactual-1,(short)13);//NOPMD
          	 HSSFRegionUtil.setBorderBottom((short)1, region, sheet, wb);
               HSSFRegionUtil.setBottomBorderColor((short)0, region, sheet, wb);
    	       row = sheet.createRow((short)lineaactual); 
    	       cell=row.createCell((short)0);
    	   	sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("1"),lineaactual,Short.parseShort("2")));//NOPMD
 	       cell=row.createCell((short)1);
 	       cell.setCellValue(W83bClsConstantes.VACIO);
    		cell=row.createCell((short)2);
    		
	       	  	
    		cell=row.createCell((short)3);
    			cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	       		cell.setCellValue((short)((Integer)datos.get("tramo1Total")).intValue());
	       	  	cell=row.createCell((short)4);
	       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
       	  		cell.setCellValue((short)((Integer)datos.get("tramo2Total")).intValue());
	       	  	cell=row.createCell((short)5);
	       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
       	  		cell.setCellValue((short)((Integer)datos.get("tramo3Total")).intValue());
       	  		
	       	  	cell=row.createCell((short)6);
	       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
       	  		cell.setCellValue((short)((Integer)datos.get("tramo4Total")).intValue());
       	  	sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("7"),lineaactual,Short.parseShort("8")));//NOPMD
	       	  	cell=row.createCell((short)7);
	       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
       	  		cell.setCellValue((short)((Integer)datos.get("tramo5Total")).intValue());
	       	  	cell=row.createCell((short)9);
	       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
       	  		cell.setCellValue((short)((Integer)datos.get("tramo6Total")).intValue());
	       	  	cell=row.createCell((short)10);
	       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
       	  		cell.setCellValue((short)((Integer)datos.get("tramo7Total")).intValue());
	       	  	cell=row.createCell((short)11);
	       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
       	  		cell.setCellValue((short)((Integer)datos.get("tramo8Total")).intValue());
       	  	  	cell=row.createCell((short)12);
       	  	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
       	  		cell.setCellValue((short)((Integer)datos.get("tramo9Total")).intValue());
       	  	  	cell=row.createCell((short)13);
       	  	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
       	  		cell.setCellValue((short)((Integer)datos.get("tramoTotalTotal")).intValue());
       	  
      	  		lineaactual=lineaactual+2;
      
            
    	}
       if(vacio)
       {
    	   sheet.shiftRows(lineaactual+1,lineaactual+3, -4);
       }
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoRepresentantesPorCandTamEmp.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	

	private HSSFCellStyle styleCentradoNumeroFormateado(W83bUtilidadesExcel excel){
		return excel.styleCentradoNumeroFormateado;			
		
	}
}
